<?php 
session_start();

require("config/conn.php");
require("functions.php");
include("includes/header.php");
include("includes/topbar.php");
include("includes/sidebar.php");

session_regenerate_id(true);

if (!isset($_SESSION['AdminLoginId'])) {
    header("Location: index.php");
} 

?>



<main>
    <div class="container-fluid px-4">

        <h1 class="mt-4 dash-heading">Badges</h1>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item active">Badges</li>
        </ol>




        <div class="row my-4">
            <div class="col-12 add-category-box">
                <h1 class="category-heading">Add Badge</h1>
                <div class="categort-add-container">
                    <form method="post" action="code.php" enctype="multipart/form-data"
                        class="d-flex align-items-center flex-wrap">
                        <div class="mb-3 mx-2">
                            <label for="image" class="form-label">Icon</label>
                            <input required name="image" type="file" class="form-control" id="image">

                        </div>
                        <div class="mb-3 mx-2">
                            <label for="title" class="form-label">Name</label>
                            <input required type="text" placeholder="Name" class="form-control" name="title" id="title">
                        </div>
                        <div class="mb-3 mx-2">
                            <label for="title" class="form-label">Greeting</label>
                            <input  type="text" placeholder="Greeting" class="form-control" name="greeting" id="greeting">
                        </div>
                        <div class="mb-3 mx-2">
                            <label for="title" class="form-label">Min Limit</label>
                            <input  required type="number" placeholder="Min Limit" class="form-control" name="minLimit" id="minLimit">
                        </div>
                        <div class="mb-3 mx-2">
                            <label for="title" class="form-label">Max Limit</label>
                            <input required  type="number" placeholder="Max Limit" class="form-control" name="maxLimit" id="maxLimit">
                        </div>
                        <button class="add-category-btn mt-3" name="add_badge" type="submit">Add</button>

                    </form>
                </div>
            </div>
        </div>

        <div class="row mb-4">

            <div class="user-table">

                <div class="useractioncontainer d-flex align-items-center justify-content-between">
                    <a herf="javascript:void(0)" onclick="delete_all()" class="delete-user-btn">Delete Selected
                        Badges</a>

                    <div class="dropdown">
                        <a class="download-data-btn dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            Download
                        </a>

                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="export.php?export_badge_csv=true">CSV</a></li>
                            <li><a class="dropdown-item" href="export.php?export_badge_excel=true">Excel</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <form method="post" id="frm">
                    <table id="example" class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th class="hide-sort"><input type="checkbox" onclick="select_all()" id="delete"></th>
                                <th class=" d-none">
                                    <?= $row['id']; ?>
                                    </td>
                                <th>SR No.</th>
                                <th>Avatar</th>
                                <th>Name</th>
                                <th>Greetings</th>
                                <th>Min Limit</th>
                                <th>Max Limit</th>

                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
            
            $sql = "SELECT * FROM `earninglevels`";

            $query_run = mysqli_query($conn, $sql);

            if ($query_run):
                if (mysqli_num_rows($query_run) > 0):

                    $i = 1;

                    foreach ($query_run as $row):
                       

                       
                        ?>



                            <tr id="box<?= $row['id']; ?>">
                                <td><input type="checkbox" name="checkbox7[]" value="<?= $row['id']; ?>"
                                        id="<?= $row['id']; ?>"></td>
                                <td class="badge_id d-none">
                                    <?= $row['id']; ?>
                                </td>
                                <td>
                                    <?= $i; ?>
                                </td>
                                <td><img style="width: 50px; height: 50px;" src="<?= $row['icon']; ?>" alt="icon">

                                <td>
                                    <?= $row['name']; ?>
                                </td>
                                <td>
                                    <?= $row['greetings']; ?>
                                </td>
                                <td>
                                    <?= $row['minLimit']; ?>
                                </td>
                                <td>
                                    <?= $row['maxLimit']; ?>
                                </td>
                                </td>

                                <td>
                                    <div class="d-flex align-items-center">
                                        <a class="edit-user edit-btn" href=""><i
                                                class="fa-solid fa-pen-to-square"></i></a>
                                        <button class="delete-user delete-badge" name="deleteUser"
                                            value="<?= $row['id']; ?>"><i class="fa-solid fa-trash"></i></button>
                                    </div>
                                </td>
                            </tr>


                            <?php

                        $i++;
                    endforeach;








                else:
                    echo "No Category Data";
                endif;
            else:
                echo "Some Error Occured";
            endif;
            
            
            
            ?>

                        </tbody>
                    </table>
                </form>


            </div>
        </div>




        <!-- Modal -->
        <div class="modal fade" id="editBadge" tabindex="-1" aria-labelledby="editBadgeLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="editBadgeLabel">Edit Game</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="code.php" method="POST" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="catLabel" class="form-label">Icon</label>
                                <div class="img-container d-flex justify-content-center align-items-center mb-4">
                                    <img alt="icon" id="icon" style="width: 100px; height: 100px;">
                                </div>
                                <input type="file" class="form-control" id="badge_image" class="badge_image"
                                    name="badge_image">
                                <input type="hidden" class="oldImage" name="oldImage">
                                <input type="hidden" class="id badge_id_edit" name="badge_id_edit">
                            </div>
                            <div class="mb-3">
                                <label for="catLabel" class="form-label">Title</label>
                                <input required type="text" class="form-control" id="badge_name" name="badge_name"
                                    class="badge_name">
                            </div>
                            <div class="mb-3">
                                <label for="catLabel" class="form-label">Greeting</label>
                                <input required type="text" class="form-control" id="greeting_edit" name="greeting_edit"
                                    class="greeting_edit">
                            </div>
                            <div class="mb-3">
                                <label for="catLabel" class="form-label">Min Limit</label>
                                <input required type="number" class="form-control" id="minLimitedit" name="minLimitedit"
                                    class="minLimitedit">
                            </div>
                            <div class="mb-3">
                                <label for="catLabel" class="form-label">Max Limit</label>
                                <input required type="number" class="form-control" id="maxLimitedit" name="maxLimitedit"
                                    class="maxLimitedit">
                            </div>



                            <button class="add-category-btn edit-categpory-btn" name="edit_badge"
                                type="submit">Save</button>

                        </form>
                    </div>
                    <div class="modal-footer">

                    </div>
                </div>
            </div>
        </div>



    </div>


    <!-- Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="deleteModalLabel">Delete Badge</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="code.php" method="post">
                    <div class="modal-body">
                        <p>Are you sure to delete this Badge ?</p>
                        <input type="hidden" name="delete_id" class="delete-badge-id" id="delete_id">
                    </div>
                    <div class="modal-footer d-flex justify-content-start">

                        <button type="submit" class="btn btn-primary delButton" name="delete_earning_badge">Yes!
                            Delete</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


</main>









<?php 

include("includes/script.php");

?>


<script>
    <?php

    if (isset($_SESSION['status'])) {
    ?>
            swal("<?= $_SESSION['message']; ?>", {
                icon: "<?= $_SESSION['icon'] ?>",

            }
            );
    <?php
  unset($_SESSION['status']);
        unset($_SESSION['message']);
        unset($_SESSION['icon']);
    }

?>


</script>


<script>
        $(document).ready(function () {
            var table = $('#example').DataTable({
                language: {
                    searchPlaceholder: "Search Category"
                },
                columnDefs: [
                    {
                        targets: 0,
                        checkboxes: {
                            selectRow: true
                        }
                    }
                ],
                select: {
                    style: 'multi'
                },
                order: [[1, 'asc']]

            });

        });



</script>
<script>





    function select_all() {
        if (jQuery('#delete').prop("checked")) {
            jQuery('input[type=checkbox]').each(function (param) {
                jQuery('#' + this.id).prop('checked', true);
                // console.log(this.id);
            });
        } else {
            jQuery('input[type=checkbox]').each(function (param) {
                jQuery('#' + this.id).prop('checked', false);
                // console.log(this.id);
            });
        }

    }




    function delete_all() {

        swal({
            title: "Are you sure?",
            text: "Are You Sure To Delete Badges !",
            icon: "warning",
            buttons: ["Cancel", "Yes ! Delete"],
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete) {
                    jQuery.ajax({
                        type: "post",
                        url: "code.php",
                        data: jQuery("#frm").serialize(),
                        success: function (response) {

                            jQuery('input[type=checkbox]').each(function () {
                                if (jQuery('#' + this.id).prop("checked")) {
                                    jQuery('#box' + this.id).remove();
                                }
                                swal({
                                    title: "Badges Deleted Successfully",
                                    text: "Badges Deleted",
                                    icon: "success",
                                });
                            });
                        }
                    });
                } else {

                }
            });



    }
</script>

<script>
    $('.edit-btn').click(function (e) {
        e.preventDefault();

        var badge_id = $(this).closest('tr').find('.badge_id').text();
        // console.log(cat_id);
        $.ajax({
            type: "POST",
            url: "code.php",
            data: {
                'checking_edit_badge_btn': true,
                'badge_id': badge_id,
            },
            success: function (response) {
                // console.log(response);
                $.each(response, function (key, value) {
                    // console.log(value['name']);
                    $("#badge_name").val(value['name']);
                    $("#greeting_edit").val(value['greetings']);
                    $("#minLimitedit").val(value['minLimit']);
                    $("#maxLimitedit").val(value['maxLimit']);
                    $(".badge_id_edit").val(value['id']);
                    $(".oldImage").val(value['icon']);
                    $("#icon").attr('src', value['icon']);



                   
                });



                $('#editBadge').modal('show');
            }
        });

    });
</script>

<script>
    $(document).ready(function () {
        $('.delete-badge').click(function (e) {
            e.preventDefault();

            var id = $(this).val();
            // console.log(user_id);
            $('.delete-badge-id').val(id);
            $('#deleteModal').modal('show')
        });
    });

</script>

<?php

include("includes/footer.php");


?>